/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.dataconnect.DatabaseManager;
import com.belenus.dataconnect.ParameterContainer;
import com.belenus.dataconnect.ResultSetRowContainer;
import com.belenus.dataconnect.Row;
import com.belenus.dataconnect.RowContainer;
import com.belenus.dataconnect.Template;
import com.belenus.interpartsserver3.FileNote;
import com.belenus.interpartsserver3.InterpartsServer;
import com.belenus.interpartsserver3.Responder;
import com.belenus.interpartsserver3.Server;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DeviceResponder
extends Responder {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$interpartsserver3$DeviceResponder == null ? (class$com$belenus$interpartsserver3$DeviceResponder = DeviceResponder.class$("com.belenus.interpartsserver3.DeviceResponder")) : class$com$belenus$interpartsserver3$DeviceResponder));
    protected InterpartsServer m_interpartsServer;
    protected DatabaseManager m_databaseManager;
    protected Properties m_queryTemplates;
    protected ArrayList m_deviceQueryKeys;
    protected HashMap m_deviceQueryKeysSplittedMap;
    protected ArrayList m_deviceMulticolumnProperties;
    protected ArrayList m_multicolumnKeys;
    protected ArrayList m_multicolumnValues;
    private ArrayList m_mappings;
    private ArrayList m_listOfFieldNameUmbrellas;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$DeviceResponder;

    public DeviceResponder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Server server) {
        super(httpServletRequest, httpServletResponse, server);
        this.m_interpartsServer = (InterpartsServer)this.m_server;
        this.m_databaseManager = this.m_interpartsServer.getDatabaseManager();
        this.m_queryTemplates = this.m_interpartsServer.m_deviceQueries;
        this.m_deviceQueryKeys = this.m_interpartsServer.m_deviceQueryKeys;
        this.m_deviceMulticolumnProperties = this.m_interpartsServer.m_deviceMulticolumnProperties;
        this.m_deviceQueryKeysSplittedMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void respond() throws Exception {
        block10: {
            this.m_httpServletResponse.setContentType("text/xml");
            this.m_databaseManager.startTransaction();
            String idParameter = this.m_httpServletRequest.getParameter("id");
            OutputStream outputStream = this.startOutputStream(true, true);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
            Element listElement = this.constructDevice(idParameter);
            Document document = DocumentHelper.createDocument((Element)listElement);
            try {
                document.write((Writer)outputStreamWriter);
                outputStreamWriter.flush();
            }
            catch (IOException exc) {
                // empty catch block
            }
            outputStreamWriter.close();
            Object var8_8 = null;
            try {
                this.m_databaseManager.finishTransaction();
            }
            catch (Exception exc2) {
                logger.error((Object)exc2, (Throwable)exc2);
            }
            break block10;
            {
                catch (Exception exc) {
                    logger.error((Object)exc, (Throwable)exc);
                    Object var8_9 = null;
                    try {
                        this.m_databaseManager.finishTransaction();
                    }
                    catch (Exception exc2) {
                        logger.error((Object)exc2, (Throwable)exc2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    this.m_databaseManager.finishTransaction();
                }
                catch (Exception exc2) {
                    logger.error((Object)exc2, (Throwable)exc2);
                }
                throw throwable;
            }
        }
    }

    private Element buildItemElement(Row row) throws SQLException {
        String idObject = row.getString("id_object").trim();
        Element itemElement = DocumentHelper.createElement((String)"item");
        itemElement.addAttribute("id", idObject);
        itemElement.addAttribute("contextid", idObject);
        this.addHotspot(row, itemElement);
        Element fieldsElement = DocumentHelper.createElement((String)"fields");
        itemElement.add(fieldsElement);
        this.addFields(row, fieldsElement);
        this.addExtlinkHref(row, fieldsElement);
        this.addSubtable(row, fieldsElement);
        this.addNote(row, itemElement);
        return itemElement;
    }

    private void addHotspot(Row row, Element itemElement) {
        RowContainer rowContainer = row.getRowContainer();
        String hotspotId = row.getString("hotspot_id");
        String hotspotFile = row.getString("hotspot_file");
        String hotspotName = row.getString("hotspot_name");
        String hotspotNumber = row.getString("hotspot_number");
        if (hotspotId != null && hotspotFile != null && !hotspotId.equals("") && !hotspotFile.equals("")) {
            Element hotspotElement = DocumentHelper.createElement((String)"hotspot");
            itemElement.add(hotspotElement);
            hotspotElement.addAttribute("id", hotspotId);
            if (hotspotNumber != null && !hotspotNumber.equals("")) {
                hotspotElement.addAttribute("posno", hotspotNumber);
                hotspotElement.addAttribute("contextid", hotspotId + "#" + hotspotNumber);
            }
            String[] hotspotFieldNames = rowContainer.getFieldNamesByMeaning("hotspot");
            for (int hotspotFieldNamesIndex = 0; hotspotFieldNamesIndex < hotspotFieldNames.length; ++hotspotFieldNamesIndex) {
                String fieldValue;
                String fieldName = hotspotFieldNames[hotspotFieldNamesIndex];
                if ("hotspot_id".equals(fieldName) || "hotspot_file".equals(fieldName) || "hotspot_name".equals(fieldName) || "hotspot_number".equals(fieldName) || (fieldValue = row.getString(fieldName)) == null || fieldValue.equals("")) continue;
                hotspotElement.addAttribute(rowContainer.nameOfField(fieldName), fieldValue);
            }
            Element aElement = DocumentHelper.createElement((String)"a");
            aElement.addAttribute("href", this.m_interpartsServer.m_dataPath + hotspotFile);
            this.addText(aElement, hotspotName);
            hotspotElement.add(aElement);
        }
    }

    private void addFields(Row row, Element fieldsElement) {
        RowContainer rowContainer = row.getRowContainer();
        String[] fieldDesriptionsByMeaning = rowContainer.getDescriptionsByMeaning("field");
        for (int fieldDesriptionsByMeaningIndex = 0; fieldDesriptionsByMeaningIndex < fieldDesriptionsByMeaning.length; ++fieldDesriptionsByMeaningIndex) {
            boolean hasContents = false;
            String description = fieldDesriptionsByMeaning[fieldDesriptionsByMeaningIndex];
            String fieldId = description.substring(6).toLowerCase();
            Element fieldElement = DocumentHelper.createElement((String)"field");
            fieldElement.addAttribute("id", fieldId);
            String[] fieldNamesByDescription = rowContainer.getFieldNamesByDescription(description);
            for (int fieldNamesByDescriptionIndex = 0; fieldNamesByDescriptionIndex < fieldNamesByDescription.length; ++fieldNamesByDescriptionIndex) {
                String text;
                String fieldName = fieldNamesByDescription[fieldNamesByDescriptionIndex];
                Locale locale = rowContainer.getLocaleFromFieldName(fieldName);
                Element valueElement = DocumentHelper.createElement((String)"value");
                if (locale != null) {
                    this.addAttribute(valueElement, "lang", locale.getLanguage());
                    if (locale.getCountry() != null) {
                        this.addAttribute(valueElement, "country", locale.getCountry());
                    }
                }
                if ((text = row.getString(fieldName)) == null || text.equals("")) continue;
                this.addText(valueElement, text);
                fieldElement.add(valueElement);
                hasContents = true;
            }
            if (!hasContents) continue;
            fieldsElement.add(fieldElement);
        }
    }

    private void old_addExtlinkHref(Row row, Element fieldsElement) {
        String idObject = row.getString("id_object").trim();
        RowContainer rowContainer = row.getRowContainer();
        String[] hrefDesriptionsByMeaning = rowContainer.getDescriptionsByMeaning("href");
        for (int hrefDesriptionsByMeaningIndex = 0; hrefDesriptionsByMeaningIndex < hrefDesriptionsByMeaning.length; ++hrefDesriptionsByMeaningIndex) {
            boolean hasContents = false;
            String description = hrefDesriptionsByMeaning[hrefDesriptionsByMeaningIndex];
            String fieldId = description.substring(5).toLowerCase();
            Element fieldElement = DocumentHelper.createElement((String)"field");
            fieldElement.addAttribute("id", fieldId);
            String[] fieldNamesByDescription = rowContainer.getFieldNamesByDescription(description);
            Element extlinkElement = DocumentHelper.createElement((String)"extlink");
            extlinkElement.addAttribute("id", "EXTLINK" + idObject);
            extlinkElement.addAttribute("contextid", "EXTLINK" + idObject);
            for (int fieldNamesByDescriptionIndex = 0; fieldNamesByDescriptionIndex < fieldNamesByDescription.length; ++fieldNamesByDescriptionIndex) {
                String href;
                String fieldName = fieldNamesByDescription[fieldNamesByDescriptionIndex];
                Locale locale = rowContainer.getLocaleFromFieldName(fieldName);
                Element aElement = DocumentHelper.createElement((String)"a");
                if (locale != null) {
                    this.addAttribute(aElement, "lang", locale.getLanguage());
                    if (locale.getCountry() != null) {
                        this.addAttribute(aElement, "country", locale.getCountry());
                    }
                }
                if ((href = row.getString("href_" + fieldId)) == null || href.equals("")) continue;
                aElement.addAttribute("href", this.m_interpartsServer.m_dataPath + href);
                fieldElement.add(extlinkElement);
                extlinkElement.add(aElement);
                hasContents = true;
                String hreftext = row.getString("hreftext_" + fieldId);
                if (hreftext == null || hreftext.equals("")) continue;
                this.addText(aElement, hreftext);
            }
            if (!hasContents) continue;
            fieldsElement.add(fieldElement);
        }
    }

    private void addExtlinkHref(Row row, Element fieldsElement) {
        String idObject = row.getString("id_object").trim();
        RowContainer rowContainer = row.getRowContainer();
        for (int mappingsIndex = 0; mappingsIndex < this.m_mappings.size(); ++mappingsIndex) {
            String mapping;
            boolean fieldHasContents = false;
            String fieldId = mapping = (String)this.m_mappings.get(mappingsIndex);
            Element fieldElement = DocumentHelper.createElement((String)"field");
            fieldElement.addAttribute("id", fieldId);
            ArrayList umbrella = (ArrayList)this.m_listOfFieldNameUmbrellas.get(mappingsIndex);
            for (int umbrellaIndex = 0; umbrellaIndex < umbrella.size(); ++umbrellaIndex) {
                boolean extlinkHasContents = false;
                Element extlinkElement = DocumentHelper.createElement((String)"extlink");
                ArrayList fieldNames = (ArrayList)umbrella.get(umbrellaIndex);
                String nameOfField = rowContainer.nameOfField((String)fieldNames.get(0));
                extlinkElement.addAttribute("id", "EXTLINK_" + nameOfField + "_" + idObject);
                extlinkElement.addAttribute("contextid", "EXTLINK_" + nameOfField + "_" + idObject);
                for (int fieldNamesIndex = 0; fieldNamesIndex < fieldNames.size(); ++fieldNamesIndex) {
                    String href;
                    String fieldName = (String)fieldNames.get(fieldNamesIndex);
                    Locale locale = rowContainer.getLocaleFromFieldName(fieldName);
                    Element aElement = DocumentHelper.createElement((String)"a");
                    if (locale != null) {
                        this.addAttribute(aElement, "lang", locale.getLanguage());
                        if (locale.getCountry() != null) {
                            this.addAttribute(aElement, "country", locale.getCountry());
                        }
                    }
                    if ((href = row.getString(fieldName)) == null || href.equals("")) continue;
                    aElement.addAttribute("href", this.m_interpartsServer.m_dataPath + href);
                    extlinkElement.add(aElement);
                    extlinkHasContents = true;
                    fieldHasContents = true;
                    String hreftextName = "hreftext_" + fieldName.substring(5);
                    String hreftext = row.getString(hreftextName);
                    if (hreftext == null || hreftext.equals("")) continue;
                    this.addText(aElement, hreftext);
                }
                if (!extlinkHasContents) continue;
                fieldElement.add(extlinkElement);
            }
            if (!fieldHasContents) continue;
            fieldsElement.add(fieldElement);
        }
    }

    private void addSubtable(Row row, Element fieldsElement) {
        String subdeviceId = row.getString("id_subdevice");
        String subqueryId = row.getString("id_subquery");
        if (subqueryId.startsWith("device.")) {
            subqueryId = subqueryId.substring("device.".length());
        }
        if (subdeviceId != null && !subdeviceId.equals("") && subqueryId != null && !subqueryId.equals("")) {
            String constructedHref = this.m_interpartsServer.m_serverDispatcher.getWebAppBase(this.m_httpServletRequest) + "server?command=device&query=" + subqueryId + "&id=" + subdeviceId;
            Element fieldElement = fieldsElement.addElement("field");
            fieldElement.addAttribute("id", "subtable");
            Element extlinkElement = fieldElement.addElement("extlink");
            extlinkElement.addAttribute("type", "subtable").addAttribute("id", subdeviceId).addAttribute("contextid", subdeviceId);
            Element aElement = extlinkElement.addElement("a");
            aElement.addAttribute("href", constructedHref);
            aElement.addText("subtable");
        }
    }

    private void addNote(Row row, Element itemElement) {
        FileNote note;
        String idObject = row.getString("id_object").trim();
        String idNote = row.getString("id_note");
        if (this.m_interpartsServer.m_noteStorage != null && (note = this.m_interpartsServer.m_noteStorage.getFileNoteByIdObject(idObject)) != null) {
            idNote = note.getIdNote();
        }
        if (idNote != null && !idNote.equals("")) {
            Element noteElement = itemElement.addElement("note");
            noteElement.addAttribute("id", idNote);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element constructDevice(String id) throws Exception {
        Element itemlistElement = DocumentHelper.createElement((String)"itemlist");
        Element tabledefElement = DocumentHelper.createElement((String)"tabledef");
        itemlistElement.add(tabledefElement);
        Element deviceElement = DocumentHelper.createElement((String)"device");
        itemlistElement.add(deviceElement);
        deviceElement.addAttribute("id", id);
        Element itemsElement = DocumentHelper.createElement((String)"items");
        deviceElement.add(itemsElement);
        String query = this.m_httpServletRequest.getParameter("query");
        String queryTemplate = (String)this.m_queryTemplates.get(query);
        if (queryTemplate == null) {
            throw new RuntimeException("Requested query template " + query + " not found in configuration.");
        }
        int position = this.m_deviceQueryKeys.indexOf(query);
        Properties multicolumnProperties = (Properties)this.m_deviceMulticolumnProperties.get(position);
        Iterator<Object> multicolumnPropertiesKeyIterator = multicolumnProperties.keySet().iterator();
        while (multicolumnPropertiesKeyIterator.hasNext()) {
            String key = (String)multicolumnPropertiesKeyIterator.next();
            this.m_deviceQueryKeys.add(key);
        }
        Template template = new Template(queryTemplate, new ParameterContainer(this.m_httpServletRequest, this.m_configurator));
        ResultSetRowContainer rowContainer = new ResultSetRowContainer(this.m_databaseManager, template);
        try {
            String parentid = null;
            String tabledeffile = null;
            while (rowContainer.hasNext()) {
                Row row = rowContainer.nextRow();
                if (parentid == null) {
                    parentid = row.getString("id_parent").trim();
                    tabledeffile = row.getString("tabledef_file");
                    ArrayList[] mappedFieldNames = rowContainer.getMappedFieldNamesByMeaning("href");
                    this.m_mappings = mappedFieldNames[0];
                    this.m_listOfFieldNameUmbrellas = mappedFieldNames[1];
                }
                Element itemElement = this.buildItemElement(row);
                itemsElement.add(itemElement);
            }
            if (parentid != null) {
                deviceElement.addAttribute("id", parentid);
            }
            if (tabledeffile != null) {
                tabledefElement.addAttribute("href", this.m_interpartsServer.m_deviceTabledefpath + tabledeffile);
            } else {
                tabledefElement.addAttribute("href", "");
            }
            Element element = itemlistElement;
            return element;
        }
        finally {
            rowContainer.destroy();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

